 aR  w ` mP9      h	 o_       nSystem-wide
    NAME CpMain

; This is cp.main.asm~text~
; This module contains all hardware dependent routines of the CompassProm

$SAVE NOLIST
$INCLUDE (`w`CcProm`Cp.Constant.Asm.Inc~Text~)
$RESTORE

%SET (notUsed, 1)
%SET (diagsReady, 1)

DGROUP GROUP DATA
CGROUP GROUP CODE


    PUBLIC CpSetKeyHandler, CpSetWatchDogHandler, CpSetMessageHandler
    PUBLIC CpCatchAll, CpEnableInterrupt, CpDisableInterrupt
    PUBLIC CpSetInterrupt, CpEndOfInterrupt
    PUBLIC CpSystemTick, CpRealTimeClock, CpMachineID
    PUBLIC tickGranularity, CompassPromStart, CpAddressOf
    PUBLIC Upper, CompareChars, CpDelay1Millisecond
    PUBLIC consoleSeg, StackSegment, StackOffset
; djm - removed
;    PUBLIC Init_CardID, Get_BootCmnd, CpLogError
; djm - end
    PUBLIC InitInterruptHandlers, InitInterruptController

; djm - added:
    PUBLIC InitControllerOnly
    PUBLIC CpSetDiagnosticHandler
    PUBLIC BirthInt

    EXTRN InitDiagnostics: FAR
    EXTRN busyStack: BYTE
    EXTRN CpLogError: FAR
    EXTRN Continue_Init: FAR

%IF (%diagsReady EQ 1) THEN (
    EXTRN DiagTest_ROM: NEAR
    EXTRN SaInit: NEAR
) FI
; djm - end

    EXTRN TimerInterrupt:FAR, InitMultiTasking:FAR
    EXTRN CpKeyPressed:NEAR, CpCharIn:NEAR


    EXTRN osProcessQ:BYTE, sysCounter:WORD
    EXTRN GpibDriver:FAR, gpibJump:BYTE, gpibOff:WORD, gpibSeg:WORD
    EXTRN cardID:BYTE, cardType:BYTE
$EJECT

; Memory mapped IO address and IO ports

; gpib

gpibSegment  EQU 0DFE0H
gpibOffset   EQU BYTE PTR 6

; real time clock

startRTC     EQU 1
rtcSeg       EQU 0DFF4H
rtcStopStart EQU BYTE PTR 29

; machine ID

machIdSeg    EQU 0DFF4H
machIdStart  EQU 1
$EJECT

%IF (%systemType EQ 0 OR %systemType EQ 1) THEN (
; interrupt controller registers

enableEdgeInterrupt       EQU 0
enableTriggeredInterrupt  EQU 1
firstTriggerableInterrupt EQU 4      ; int0 offset
turnOnLevelTrigger        EQU 10H    ; LTM (level/trigger mode) bit
firstTriggerableCntlReg   EQU 0FF38H ; same as int0

endOfIntReg      EQU 0FF22H
pollRegister     EQU 0FF24H
pollStatReg      EQU 0FF26H
intMaskReg       EQU 0FF28H
priMaskReg       EQU 0FF2AH
inServiceReg     EQU 0FF2CH
intRequestReg    EQU 0FF2EH
intCntlStatReg   EQU 0FF30H
timerCntlReg     EQU 0FF32H    ; 0
dma0CntlReg      EQU 0FF34H    ; 2
dma1CntlReg      EQU 0FF36H    ; 3
int0CntlReg      EQU 0FF38H    ; 4
int1CntlReg      EQU 0FF3AH    ; 5
int2CntlReg      EQU 0FF3CH    ; 6
int3CntlReg      EQU 0FF3EH    ; 7

timer0Mode       EQU 0FF56H
timer1Mode       EQU 0FF5EH
timer2Mode       EQU 0FF66H

timerMask        EQU 1

timer0Offset     EQU 0
timer1Offset     EQU 10
timer2Offset     EQU 11

timerIntEnable   EQU 02000H    ; OR to enable
timerIntDisable  EQU 0DFFFH    ; AND to disable

; interrupt controller bytes

initCntlState EQU 08h
) FI
%IF (%systemType EQ 2) THEN (
; interrupt controller 

interruptInit    EQU 0
interruptOper    EQU 2

interruptEOI     EQU 0
intMaskReg       EQU 2

; interrupt controller bytes

icw1             EQU 013H      ; edge triggered, single 8259, ICW4 needed
icw2             EQU 020H      ; use interrupts 32 through 39 (decimal)
icw4             EQU 00DH      ; 8086 mode, normal EOI, buffered mode
ocw1             EQU 0FFH      ; enable no interrupts
) FI

; catch all constants

catchReadDelayRepeat  EQU 0
catchWriteDelayRepeat EQU 1
catchReadStatusKey    EQU 2
catchSysControl       EQU 3
catchRepeat           EQU 4
catchKeyboard         EQU 5
catchWatchdog         EQU 6
catchBlank            EQU 7
catchInvert           EQU 8
catchDma              EQU 9
catchResetWatchDog    EQU 10
catchSetWatchDog      EQU 11
catchReadKbdStatus    EQU 12
$EJECT

DATA SEGMENT PUBLIC 'DATA'

stackSegment       DW ?      ; stack segment
stackOffset        DW ?      ; stack offset, set in DiagTest_Ram
keyHandlerOff      DW ?
keyHandlerSeg      DW ?      ; address of current key handler routine

watchDogHandlerOff DW ?
watchDogHandlerSeg DW ?      ; address of current watch dog routine

messageHandlerOff  DW ?
messageHandlerSeg  DW ?      ; address of current message passing routine

; djm - added:
diagHandlerOff     DW ?
diagHandlerSeg     DW ?      ; address of current diagnostic handling routine
; djm - end

keyboardStatusKey  DW ?      ; the previous status and character of keyboard

bootCommand        DW ?      ; boot command from the 8051 processor (power-on)
consoleSeg         DW ?      ; segment where 8051 messages are sent / received
; djm - removed
; promErrorLogSeg    DW ?      ; segment where errors to be logged are sent to 8051
DATA ENDS


CODE SEGMENT PUBLIC 'CODE'
     ASSUME CS:CGROUP, DS:DGROUP

DataFrame       DW DATA      ; segment of data

tickGranularity DW 10        ; system tick granularity


; interrupt table
; This table will map a virtual interrupt ID to its real priority mask
; 8 means unused

; This is for the 80186 with an external timer

;%IF (%systemType EQ 0) THEN (
;interruptTable DB   8,   5,   8,   6,   8,   8,   8,   8,   7
;) FI

; This is for the 80186 with internal timers

%IF (%systemType EQ 0) THEN (
interruptTable DB   8,   5,   8,  11,   8,   8,   8,   8,   7,   8,   2,   3,   6,   4,  10
) FI

%IF (%systemType EQ 1) THEN (
interruptTable DB   8,   8,   8,  11,   8,   8,   4,   7,   5,   0,   2,   3
) FI

%IF (%systemType EQ 2) THEN (
interruptTable DB   3,   8,   8,   0,   8,   8,   8,   8,   2
) FI

; This table is the same as interruptTable except everything is a power of 2

; This is for the 80186 with an external timer

;%IF (%systemType EQ 0) THEN (
;interruptMask  DB   0,  32,   0,  64,   0,   0,   0,   0, 128
;) FI

; This is for the 80186 with internal timers

%IF (%systemType EQ 0) THEN (
interruptMask  DB   0,  32,   0,   1,   0,   0,   0,   0, 128,   0,   4,   8,  64,  16,   1
) FI

%IF (%systemType EQ 1) THEN (
interruptMask  DB   0,   0,   0,   1,   0,   0,  16, 128,  32,   1,   4,   8
) FI

%IF (%systemType EQ 2) THEN (
interruptMask  DB   8,   0,   0,   1,   0,   0,   0,   0,   4
) FI

%IF (%systemType EQ 0 OR %systemType EQ 1) THEN (
; This table is for the timerMode registers

; NOTE: The 2nd entry in this table is a NULL place
;       holder, it should never be used.

timerModeTable DW   timer0Mode, timer0Mode, timer1Mode, timer2Mode
) FI

; this maps a rtc mode to its offset into the chip

           ;0  1  2  3  4   5   6   7   8   9  10  11  12  13  14  15
rtcTable DB 1, 3, 5, 7, 9, 11, 13, 15, 17, 19, 21, 23, 25, 27, 29, 31
$EJECT

;    NullInterruptRoutine
;
;    This will do an IRET and nothing more

NullInterruptRoutine PROC FAR

    IRET
NullInterruptRoutine ENDP


;    NullRoutine
;
;    This will just do a long return

NullRoutine PROC FAR

    RET
NullRoutine ENDP


;    CpDelay1Millisecond
;
;    This routine delays for 1 millisecond
;    It does NOT destroy any register values

CpDelay1Millisecond PROC NEAR
    PUSH CX
    MOV  CX, 300

CpDelay1MilliLoop:
    LOOP CpDelay1MilliLoop

    POP  CX
    RET
CpDelay1Millisecond ENDP
$EJECT

;  Upper: PROCEDURE (char) BYTE CLEAN;
;    DCL char BYTE;
;
;    This will return the upper case value of a letter.

char EQU BYTE PTR [BP+8]

Upper PROC FAR
    PUSH DS
    PUSH BP
    MOV  BP, SP

    MOV  AL, char
    CMP  AL, 'a'
    JB   UpperExit
    CMP  AL, 'z'
    JA   UpperExit
    AND  AL, 0DFH

UpperExit:
    POP  BP
    POP  DS
    RET  2
Upper ENDP

PURGE char
$EJECT

;  CompareChars: PROCEDURE (pString1, pString2, length) BOOLEAN CLEAN;
;    DCL lenCompare WORD;
;    DCL pString1   PTR;
;    DCL pString2   PTR;
;
;    This will return TRUE if two buffers are equal.  Case is ignored.
;
;    NOTE: This routine depends on the routine
;      Upper only changing register AL.

lenCompare EQU WORD  PTR [BP+8]
pString2   EQU DWORD PTR [BP+10]
pString1   EQU DWORD PTR [BP+14]

CompareChars PROC FAR
    PUSH DS
    PUSH BP
    MOV  BP, SP

    MOV  CX, lenCompare
    JCXZ CompareEqual

    LDS  SI, pString1
    LES  DI, pString2

CompareTopOfLoop:
    MOV  AL, DS:[SI]      ; get the Upper of the
    PUSH AX
    CALL Upper            ; byte at string1 (next)
    MOV  BL, AL           ; save this Upper value

    MOV  AL, ES:[DI]      ; get the Upper of the
    PUSH AX
    CALL Upper            ; byte at string2 (next)

    CMP  AL, BL           ; if the characters
    MOV  AL, false        ; do not match, then
    JNZ  CompareExit      ; RETURN (FALSE)

    INC  SI               ; point to next str1 char
    INC  DI               ; point to next str2 char
    LOOP CompareTopOfLoop ; keep checking

CompareEqual:
    MOV  AL, true         ; RETURN (TRUE);

CompareExit:
    POP  BP
    POP  DS
    RET  10
CompareChars ENDP

PURGE lenCompare, pString2, pString1
$EJECT

;    CpEnableInterrupt: PROCEDURE (interruptID,mode) CLEAN;
;        DCL interruptID BYTE;
;        DCL mode        BYTE;
;
;    This will enable the interrupt of the given ID.  It will not
;    change the state of any other interrupts.

mode        EQU BYTE PTR [BP+8]
interruptID EQU BYTE PTR [BP+10]

CpEnableInterrupt PROC FAR
    PUSH DS
    PUSH BP
    MOV  BP, SP

    MOV  BL, interruptID
    MOV  BH, 0
    MOV  AL, CS:interruptMask[BX]   ; AL = mask

%IF (%systemType EQ 0 OR %systemType EQ 1) THEN (
    CMP  AL, timerMask
    JZ   CpEnableTimerInterrupt
) FI

%IF (%systemType EQ 0 OR %systemType EQ 1) THEN (
    CMP  mode, enableEdgeInterrupt  ; if edge triggered interrupt
    JZ   NotLevelTriggeredInterrupt ; then continue

    PUSH AX                         ; save mask
    MOV  AL, CS:interruptTable[BX]  ; AL = intr addr offset
    CMP  AL, firstTriggerableInterrupt
    JB   NotLevelTriggerableInterrupt

    MOV  AH, 0
    SUB  AX, firstTriggerableInterrupt
    SHL  AX, 1
    MOV  DX, firstTriggerableCntlReg
    ADD  DX, AX

    PUSHF                           ; save flag state
    CLI                             ; disable interrupts
    IN   AX, DX                     ; get current control info
    OR   AX, turnOnLevelTrigger
    OUT  DX, AX                     ; then output it
    POPF                            ; restore flags

NotLevelTriggerableInterrupt:
    POP  AX

NotLevelTriggeredInterrupt:
) FI

    MOV  AH, 0
    NOT  AL                         ; prepare for reseting bit

    MOV  BX, AX
    MOV  DX, intMaskReg

    PUSHF                           ; save flag state
    CLI                             ; disable interrupts
    IN   AX, DX                     ; get current mask
    AND  AX, BX
    OUT  DX, AX                     ; AND then output it
    POPF                            ; restore flags

%IF (%systemType EQ 0 OR %systemType EQ 1) THEN (
    JMP  SHORT CpEnableIntExit

CpEnableTimerInterrupt:
    MOV  AL, CS:interruptTable[BX]  ; AL = intr addr offset
    AND  AX, 3H
    SHL  AX, 1
    MOV  BX, AX
    MOV  DX, CS:timerModeTable[BX]

    PUSHF
    CLI
    IN   AX, DX
    OR   AX, timerIntEnable
    OUT  DX, AX
    POPF
) FI

CpEnableIntExit:
    POP  BP
    POP  DS
    RET  4
CpEnableInterrupt ENDP

PURGE mode, interruptID
$EJECT

;    CpDisableInterrupt : PROCEDURE (interruptID) CLEAN;
;        DCL interruptID BYTE;
;
;    This will disable the interrupt of the given ID.  It will not
;    change the state of any other interrupts.

interruptID EQU BYTE PTR [BP+8]

CpDisableInterrupt PROC FAR
    PUSH DS
    PUSH BP
    MOV  BP, SP

    MOV  BL, interruptID
    MOV  BH, 0
    MOV  AL, CS:interruptMask[BX]   ; AL = mask

%IF (%systemType EQ 0 OR %systemType EQ 1) THEN (
    CMP  AL, timerMask
    JZ   CpDisableTimerInterrupt
) FI

    MOV  BL, AL
    MOV  DX, intMaskReg

    PUSHF                           ; save flags
    CLI                             ; disable
    IN   AX, DX                     ; get original mask
    OR   AX, BX
    OUT  DX, AX                     ; OR new one
    POPF                            ; restore flags

%IF (%systemType EQ 0 OR %systemType EQ 1) THEN (
    JMP  SHORT CpDisableIntExit

CpDisableTimerInterrupt:
    MOV  AL, CS:interruptTable[BX]  ; AL = intr addr offset
    AND  AX, 0003H
    SHL  AX, 1
    MOV  BX, AX
    MOV  DX, CS:timerModeTable[BX]

    PUSHF
    CLI
    IN   AX, DX
    AND  AX, timerIntDisable
    OUT  DX, AX
    POPF
) FI

CpDisableIntExit:
    POP  BP
    POP  DS
    RET  2
CpDisableInterrupt ENDP

PURGE interruptID
$EJECT

;    CpSetInterrupt: PROCEDURE (interruptID, pRoutine) PTR CLEAN;
;        DCL interruptID BYTE;
;        DCL pRoutine    PTR;
;
;    This will set up an interrupt vector and return the previous value.

pRoutine    EQU DWORD PTR [BP+8]
interruptID EQU BYTE  PTR [BP+12]

CpSetInterrupt PROC FAR
   PUSH DS
   PUSH BP
   MOV  BP, SP
   PUSHF
   CLI

   XOR  BX, BX
   MOV  DS, BX                      ; DS = interrupt vectors

   MOV  BL, interruptID
   MOV  BL, CS:interruptTable[BX]   ; BL = real interrupt number

   SHL  BX, 1
   SHL  BX, 1                       ; BX := BX * 4

%IF (%systemType EQ 0 OR %systemType EQ 1) THEN (
   ADD  BX, 8 * 4                   ; Add offset of first hardware int vector
) FI
%IF (%systemType EQ 2) THEN (
   ADD  BX, 32 * 4                  ; Add offset of first hardware int vector
) FI

   LES  CX, DWORD PTR DS:[BX]       ; get current routine

   PUSH ES                          ; save segment

   LES  DX, pRoutine
   MOV  DS:[BX], DX                 ; save new offset
   MOV  DS:[BX+2], ES               ; save new segment

   POP  ES                          ; return old vector
   MOV  BX, CX

   POPF
   POP  BP
   POP  DS
   RET  6
CpSetInterrupt ENDP

PURGE interruptID, pRoutine
$EJECT

;    CpEndOfInterrupt : PROCEDURE (interruptID) CLEAN;
;        DCL interruptID BYTE;
;
;    This will do a specific "end of interrupt" for the given ID

interruptID EQU BYTE PTR [BP+8]

CpEndOfInterrupt PROC FAR
   PUSH DS
   PUSH BP
   MOV  BP, SP

   MOV  BH, 0
   MOV  BL, interruptID

%IF (%systemType EQ 0 OR %systemType EQ 1) THEN (
   MOV  AX, 0                       ; AX := specific EOI
   MOV  AL, CS:interruptTable[BX]   ; AL := real interrupt #

   CMP  AL, timer1Offset            ; If timer1 or timer 2
   JB   CpEndNotTimer1or2
   XOR  AL, AL                      ; use timer0 EOI

CpEndNotTimer1or2:
   ADD  AX, 8                       ; add hardware interrupt base

   MOV  DX, endOfIntReg
   OUT  DX, AX                      ; tell the chip
) FI
%IF (%systemType EQ 2) THEN (
   MOV  AL, 060H                    ; AL := specific EOI
   OR   AL, CS: interruptTable[BX]  ; AL := (real interrupt#) OR AL
   MOV  DX, interruptEOI
   OUT  DX, AL                      ; tell the chip
) FI

   POP  BP
   POP  DS
   RET  2
CpEndOfInterrupt ENDP

PURGE interruptID
$EJECT

;    CpSetKeyHandler: PROCEDURE (pRoutine) PTR CLEAN;
;        DCL pRoutine PTR;
;
;    This will set up a new key handler and return the old one

pRoutine EQU DWORD PTR [BP+8]

CpSetKeyHandler PROC FAR
    PUSH DS
    MOV  DS, CS:DataFrame
    PUSH BP
    MOV  BP, SP

    MOV  DX, DS:keyHandlerSeg       ; get old one

    LES  BX, pRoutine

    XCHG DS:keyHandlerOff, BX
    MOV  DS:keyHandlerSeg, ES       ; save new one

    MOV  ES, DX                     ; return old one

    POP  BP
    POP  DS
    RET  4
CpSetKeyHandler ENDP

PURGE pRoutine
$EJECT

;    CpSetMessageHandler: PROCEDURE (pRoutine) PTR CLEAN;
;        DCL pRoutine PTR;
;
;    This will set up a new message passing handler and return the old one

pRoutine EQU DWORD PTR [BP+8]

CpSetMessageHandler PROC FAR
    PUSH DS
    MOV  DS, CS:DataFrame
    PUSH BP
    MOV  BP, SP

    MOV  DX, DS:messageHandlerSeg   ; get old one

    LES  BX, pRoutine
    XCHG DS:messageHandlerOff, BX
    MOV  DS:messageHandlerSeg, ES   ; save new one

    MOV  ES, DX                     ; return old one

    POP  BP
    POP  DS
    RET  4
CpSetMessageHandler ENDP

PURGE pRoutine
$EJECT

; djm - added:

;    CpSetDiagnosticHandler: PROCEDURE (pRoutine) PTR CLEAN;
;        DCL pRoutine PTR;
;
;    This will set up a new Diagnostic handler and return the old one

pRoutine EQU DWORD PTR [BP+8]

CpSetDiagnosticHandler PROC FAR
    PUSH DS
    MOV  DS, CS:DataFrame
    PUSH BP
    MOV  BP, SP

    MOV  DX, DS:DiagHandlerSeg      ; get old one

    LES  BX, pRoutine
    XCHG DS:DiagHandlerOff, BX
    MOV  DS:DiagHandlerSeg, ES      ; save new one

    MOV  ES, DX                     ; return old one

    POP  BP
    POP  DS
    RET  4
CpSetDiagnosticHandler ENDP

PURGE pRoutine
; djm - end
$EJECT

;    CpSetWatchDogHandler: PROCEDURE (pRoutine) PTR CLEAN;
;        DCL pRoutine PTR;
;
;    This will set up a new watch dog handler and return the old one

pRoutine EQU DWORD PTR [BP+8]

CpSetWatchDogHandler PROC FAR
;    PUSH DS
;    MOV  DS, CS:DataFrame
;    PUSH BP
;    MOV  BP, SP

;    MOV  DX, DS:watchDogHandlerSeg  ; get old one

;    LES  BX, pRoutine
;    XCHG DS:watchDogHandlerOff, BX
;    MOV  DS:watchDogHandlerSeg, ES  ; save new one

;    MOV  ES, DX                     ; return old one

;    POP  BP
;    POP  DS
    RET  4
CpSetWatchDogHandler ENDP

PURGE pRoutine
$EJECT

;    SystemTickInt: PROCEDURE INTERRUPT;
;

SystemTickInt PROC FAR
    PUSH  ES
    PUSH  DS
    MOV   DS, CS:DataFrame
    PUSH  AX
    PUSH  CX
    PUSH  DX
    PUSH  BX
    PUSH  SI
    PUSH  DI
    PUSH  BP

    MOV  AL, intSysTick
    PUSH AX
    CALL CpEndOfInterrupt           ; set end of interrupt

    MOV  AX, CS:tickGranularity
    ADD  WORD PTR DS:sysCounter, AX ; increment sys counter
    ADC  WORD PTR DS:sysCounter+2, 0

    CALL TimerInterrupt

    CALL CpKeyPressed
    RCR  AL, 1
    JNB  SystemTickIntExit

    CALL CpCharIn

; note - status part of CpCharIn is always = 0

    MOV  DS:keyboardStatusKey, AX   ; save key and status
    CALL DWORD PTR DS:keyHandlerOff ; call key routine

SystemTickIntExit:
    POP  BP
    POP  DI
    POP  SI
    POP  BX
    POP  DX
    POP  CX
    POP  AX
    POP  DS
    POP  ES
    IRET
SystemTickInt ENDP
$EJECT

;    MessageInt: PROCEDURE INTERRUPT;
;

MessageInt PROC FAR
    PUSH  ES
    PUSH  DS
    MOV   DS, CS:DataFrame
    PUSH  AX
    PUSH  CX
    PUSH  DX
    PUSH  BX
    PUSH  SI
    PUSH  DI
    PUSH  BP

    MOV  AL, intMessage
    PUSH AX
    CALL CpEndOfInterrupt               ; set end of interrupt

    MOV  DX, msgIntReset
    OUT  DX, AX                         ; re-latch message passing interrupt

; djm - added:
    CALL DWORD PTR DS:diagHandlerOff    ; call diagnostic message handling routine
; djm - end

    CALL DWORD PTR DS:messageHandlerOff ; call message passing routine

    POP  BP
    POP  DI
    POP  SI
    POP  BX
    POP  DX
    POP  CX
    POP  AX
    POP  DS
    POP  ES
    IRET
MessageInt ENDP
$EJECT

;    GlitchInt: PROCEDURE INTERRUPT;
;

;GlitchInt PROC FAR
;    PUSH  ES
;    PUSH  DS
;    MOV   DS, CS:DataFrame
;    PUSH  AX
;    PUSH  CX
;    PUSH  DX
;    PUSH  BX
;    PUSH  SI
;    PUSH  DI
;    PUSH  BP

;    MOV  AL, intGlitch
;    PUSH AX
;    CALL CpEndOfInterrupt           ; set end of interrupt

;    POP  BP
;    POP  DI
;    POP  SI
;    POP  BX
;    POP  DX
;    POP  CX
;    POP  AX
;    POP  DS
;    POP  ES
;    IRET
;GlitchInt ENDP
$EJECT

;    CpSystemTick: PROCEDURE (mode) WORD CLEAN;
;        DCL mode BYTE;
;
;    This will turn on (mode = 1) or turn off (mode = 0) the system tick.
;    It will also return the system tick granularity.

mode EQU BYTE PTR [BP+8]

CpSystemTick PROC FAR
    PUSH DS
    PUSH BP
    MOV  BP, SP

    CMP  mode, 2                ; if mode >= 2 then just return tickGranularity
    JAE  CpSystemCont

    MOV  AX, intSysTick
    PUSH AX

    CMP  mode, 0                ; IF mode = on THEN
    JE   CpSystemOff

    PUSH AX                     ;     ignored

    CALL CpEnableInterrupt      ;     enable interrupt
    JMP  SHORT CpSystemCont

CpSystemOff:                    ; ELSE
    CALL CpDisableInterrupt     ;     turn off interrupt

CpSystemCont:
    MOV  AX, CS:tickGranularity

    POP  BP
    POP  DS
    RET  2
CpSystemTick ENDP

PURGE mode
$EJECT

;    CpMachineID: PROCEDURE (pMachineID) CLEAN;
;        DCL pMachineID PTR;
;
;    This will return the 8 byte machine ID

pMachineID EQU DWORD PTR [BP+8]

CpMachineID PROC FAR
    PUSH DS
    PUSH BP
    MOV  BP, SP

    LES  DI, pMachineID

    MOV  AX, machIdSeg
    MOV  DS, AX                 ; DS:SI ^ machine ID
    MOV  SI, machIdStart
    MOV  CX, 8                  ; loop 8 times

CpMachineLoop:
    MOV  AH, DS:[SI]            ; get 4 bits in high nibble
    ADD  SI, 2                  ; SI ^ next 4 bits

    SHR  AH, 1
    SHR  AH, 1
    SHR  AH, 1                  ; move into low nibble
    SHR  AH, 1                  ; high nibble gets zero

    MOV  AL, DS:[SI]            ; get next 4 bits
    ADD  SI, 2

    AND  AL, 0F0H               ; clear low nibble
    OR   AL, AH                 ; add in low order nibble
    MOV  ES:[DI], AL            ; store in users buffer
    INC  DI

    LOOP CpMachineLoop

    POP  BP
    POP  DS
    RET  4
CpMachineID ENDP

PURGE pMachineID
$EJECT

;    CpRealTimeClock : PROCEDURE (mode) BYTE CLEAN;
;
;    This will return 1 byte from the RTC

mode EQU BYTE PTR [BP+8]
rtcLoopCount EQU 5000
rtcMask EQU 0fh

CpRealTimeClock PROC FAR
   PUSH DS
   PUSH BP
   MOV  BP, SP

   MOV  AX, rtcSeg
   MOV  DS, AX

   MOV  BL, mode
   MOV  BH, 0
   MOV  BL, CS:rtcTable[BX]          ; BX = offset into RTC

   MOV  CX, rtcLoopCount             ; try this many times

CpRealLoop:
   MOV  AL, DS:[BX]
   AND  AL, rtcMask                  ; get low nibble from RTC

   CMP  AL, rtcMask
   LOOPE CpRealLoop                  ; loop if equal to mask

   POP  BP                           ; return AL
   POP  DS
   RET  2
CpRealTimeClock ENDP

PURGE mode
$EJECT

;    CpAddressOf : PROCEDURE PTR CLEAN;
;
;    This will return the start of the block
;    of variables of the prom

CpAddressOf PROC FAR

    MOV  AX, SEG OsProcessQ
    MOV  ES, AX                    ; OsProcessQ is first variable in this area
    MOV  BX, OFFSET OsProcessQ

    RET
CpAddressOf ENDP



;    CpCatchAll: PROCEDURE (command,theData) WORD CLEAN;
;       DCL  command   WORD;
;       DCL  theData   WORD;
;
;    This routine is used to program, and retrieve
;    information from many different parts of the system

theData EQU BYTE PTR [BP+8]
command EQU BYTE PTR [BP+10]

CpCatchAll PROC FAR
    PUSH DS
    MOV  DS, CS:DataFrame
    PUSH BP
    MOV  BP, SP

;   MOV  AH, theData
    MOV  AL, command

    CMP  AL, catchReadStatusKey
    JNE  CpCatchDone

    MOV  AX, keyboardStatusKey      ; read keyboard status

CpCatchDone:
    POP  BP
    POP  DS
    RET  4
CpCatchAll ENDP

PURGE command, theData

; djm - removed and replaced
%IF (%notUsed EQ 0) THEN (
$EJECT

; CpLogError: PROCEDURE (request, pMessage)
;
;   This routine will store a message in common RAM
;   and notify the 8051 diagnostics processor.
;   The processor will store the message into its
;   error log and display it.  The request has these meanings:
;     1 - This is an error
;     2 - This is a display message only
;     3 - End of boot has happened

pMessage  EQU DWORD PTR [BP+8]
request   EQU BYTE  PTR [BP+12]

CpLogError PROC FAR
    PUSH DS
    PUSH BP
    MOV  BP, SP

    MOV  DS, CS:DataFrame        ; use prom's DS

    MOV  AX, DS:promErrorLogSeg
    MOV  ES, AX

CpLogWaitFor8051Ready:
    CMP  ES: errorLogReqChk, 0   ; wait for request and chkSum to = 0
    JZ   CpLogReadyForMessage

    CALL CpDelay1Millisecond     ; else wait for 1 millisecond
    JMP  SHORT CpLogWaitFor8051Ready

CpLogReadyForMessage:
    MOV  DI, errorLogMsgOffset   ; ES:DI points to msg destination
    LDS  SI, pMessage            ; DS:SI points to msg source
    MOV  CX, 6                   ; 12 bytes in message
    CLD
    JMP  SHORT CpLogMOVWBugFix   ; Fix for MOVW bug in 80186

CpLogMOVWBugFix:
    REP  MOVSW

    MOV  AL, request
    MOV  AH, 0CBH
    MOV  ES: errorLogReqChk, AX

    MOV  DX, intr8051Port
    XOR  AX, AX
    OUT  DX, AX                  ; interrupt card 0

    POP  BP
    POP  DS
    RET  6
CpLogError ENDP

PURGE request, pMessage
)FI
$EJECT

;    InitInterruptController
;
;    This will initialize the interrupt controller to the default values
;    After this, no interrupts are enabled
;    ES, DX, AX are changed

InitInterruptController PROC NEAR
    XOR  AX, AX
    MOV  ES, AX                     ; ES:[BX] = interrupt vectors
    XOR  BX, BX
    MOV  CX, 256                    ; number of interrupt vectors

InitInterruptLoop:
    MOV  ES:[BX],   OFFSET NullInterruptRoutine
    MOV  ES:[BX+2], SEG    NullInterruptRoutine
                                    ; make all interrupts vectors null routines
    ADD  BX, 4
    LOOP InitInterruptLoop


InitControllerOnly:

%IF (%systemType EQ 0 OR %systemType EQ 1) THEN (
    XOR  AX, AX
    MOV  DX, timerCntlReg
    OUT  DX, AX

    MOV  AX, initCntlState

    MOV  DX, dma0CntlReg
    OUT  DX, AX
    MOV  DX, dma1CntlReg
    OUT  DX, AX
    MOV  DX, int0CntlReg
    OUT  DX, AX
    MOV  DX, int1CntlReg
    OUT  DX, AX
    MOV  DX, int2CntlReg
    OUT  DX, AX
    MOV  DX, int3CntlReg
    OUT  DX, AX
) FI

%IF (%systemType EQ 2) THEN (
    MOV  DX, interruptInit
    MOV  AX, icw1
    OUT  DX, AX

    MOV  DX, interruptOper
    MOV  AX, icw2
    OUT  DX, AX

    MOV  AX, icw4
    OUT  DX, AX

    MOV  AX, ocw1
    OUT  DX, AX
) FI

    RET
InitInterruptController ENDP
$EJECT

;    InitInterruptHandlers: PROCEDURE
;
;    This will initialize the keyboard chip
;    and other message interrupt handlers.
;    Also set message handlers to null routine

InitInterruptHandlers PROC NEAR
    MOV  DS:gpibJump, 0EAH             ; set the long jump instruction
    MOV  DS:gpibOff, OFFSET GpibDriver ; Initialize it to the
    MOV  DS:gpibSeg, SEG    GpibDriver ; prom GPIB Driver

    MOV  DS:watchDogHandlerOff, OFFSET NullRoutine
    MOV  DS:watchDogHandlerSeg, SEG    NullRoutine

    MOV  DS:keyHandlerOff, OFFSET NullRoutine
    MOV  DS:keyHandlerSeg, SEG    NullRoutine

    MOV  DS:keyboardStatusKey, 0

    MOV  AX, intSysTick
    PUSH AX                          ; set up system tick interrupt
    MOV  AX, SEG    SystemTickInt
    PUSH AX
    MOV  AX, OFFSET SystemTickInt
    PUSH AX
    CALL CpSetInterrupt

; djm - added:
;                                      make sure message handlers are nop

    MOV  DS: messageHandlerOff, OFFSET NullRoutine
    MOV  DS: messageHandlerSeg, SEG    NullRoutine

    MOV  DS: diagHandlerOff, OFFSET NullRoutine
    MOV  DS: diagHandlerSeg, SEG    NullRoutine
; djm - end

    MOV  AX, intMessage
    PUSH AX                          ; set up message passing interrupt
    MOV  AX, SEG    MessageInt
    PUSH AX
    MOV  AX, OFFSET MessageInt
    PUSH AX
    CALL CpSetInterrupt

;   MOV  AX, intGlitch
;   PUSH AX                          ; set up glitch interrupt
;   MOV  AX, SEG    GlitchInt
;   PUSH AX
;   MOV  AX, OFFSET GlitchInt
;   PUSH AX
;   CALL CpSetInterrupt

    RET
InitInterruptHandlers ENDP
$EJECT
; djm - modified following routine:

;    CompassPromStart
;
;    This will intialize all the parts of the computer,
;    start up the multitasking, and then boot the system

CompassPromStart PROC FAR
;   PUSH  DS
;   PUSH  BP

    CLI

    MOV  DS, CS:DataFrame

; djm - added
    CALL InitDiagnostics          ; init for diagnostic handling
; djm - end

    PUSH DS
    CALL SaInit                   ; init prom debugger
    POP  DS

    STI                           ; enable interrupts
Startloop:
    NOP                           ; and halt
    JMP  StartLoop                ; never returns, control handled elsewhere

;    POP  BP
;    POP  DS
;    RET
CompassPromStart ENDP

$EJECT
; djm - added:

;    BirthInt: PROCEDURE INTERRUPT;
;
;    Since this is called before things are initialized,
;    dont care about saving registers. Also, this routine
;    never returns. Control is passed to init code.

BirthInt PROC FAR

    MOV   DS, CS:DataFrame

    MOV  AL, intMessage                 ; set end of interrupt
    PUSH AX
    CALL CpEndOfInterrupt               

    MOV  DX, msgIntReset                ; re-latch message passing interrupt
    OUT  DX, AX                         

    MOV  AX, commonRamSeg               ; get ptr to birth message area
    MOV  ES, AX

    MOV  AL, ES:bootCardId              ; make sure this is valid birth
    CMP  AL, 8
    JL   continueBirth
    IRET

ContinueBirth:
    MOV  AL, ES:doSelfTest              ; check self test variable in birth msg
    CMP  AL, 0
    JNE  GotoTest                       ; if yes, then do on-board tests

; djm - change stack to use busy stack
    MOV  AX, DS
    MOV  SS, AX
    MOV  AX, OFFSET busyStack
    ADD  AX, 300
    MOV  SP, AX
; djm - end

    CALL Continue_Init
    
    JMP  CompassPromStart               ; else just go to init code

GotoTest:
    JMP  DiagTest_ROM

;   IRET                               ; never returns
BirthInt ENDP
; djm - end

%IF (%diagsReady EQ 0) THEN (
DiagTest_ROM PROC NEAR

    MOV  AX, 1600h
    MOV  SS, AX
    MOV  AX, 1000h
    MOV  SP, AX

    CALL Continue_Init
    
    MOV  AX, 5                          ; send continue test message
    PUSH AX
    PUSH AX                             ; dont care about msg ptr
    PUSH AX
    CALL CpLogError                     

    MOV  AX, 5                          ; send continue test message
    PUSH AX
    PUSH AX                             ; dont care about msg ptr
    PUSH AX
    CALL CpLogError                     

    MOV  AX, 6                          ; send end of test message
    PUSH AX
    PUSH AX                             ; dont care about msg ptr
    PUSH AX
    CALL CpLogError                     

    JMP  CompassPromStart               ; else just go to init code
    
DiagTest_ROM ENDP

SaInit PROC NEAR

    RET

SaInit ENDP
) FI

CODE ENDS

    END
